#include "adf4252.h"
#include <msp430.h>
#include <inttypes.h>

void adf4252_sw_spi_write(uint32_t data) {
	int i = 24;
	
	ADF4252_LE_POUT &= ~ADF4252_LE;
	while (i-- > 0) {
		if ((data >> i) & 0x01) {
			ADF4252_DATA_POUT |= ADF4252_DATA;
		} else {
			ADF4252_DATA_POUT &= ~ADF4252_DATA;
		}
		ADF4252_CLK_POUT |= ADF4252_CLK;
		ADF4252_CLK_POUT &= ~ADF4252_CLK;
	}
	ADF4252_LE_POUT |= ADF4252_LE;
}

void adf4252_sw_spi_init(void) {
	ADF4252_LE_POUT |= ADF4252_LE;
	ADF4252_LE_PDIR |= ADF4252_LE;
	ADF4252_CLK_POUT &= ~ADF4252_CLK;
	ADF4252_CLK_PDIR |= ADF4252_CLK;
	ADF4252_DATA_POUT &= ~ADF4252_DATA;
	ADF4252_DATA_PDIR |= ADF4252_DATA;
}

void adf4252_config(void) {    
	adf4252_sw_spi_init();

    __delay_cycles(10000);

	adf4252_sw_spi_write(ADF4252_R0);
	adf4252_sw_spi_write(ADF4252_R1);
	adf4252_sw_spi_write(ADF4252_R2);
	adf4252_sw_spi_write(ADF4252_R3);
	adf4252_sw_spi_write(ADF4252_R4);
	adf4252_sw_spi_write(ADF4252_R5);
	adf4252_sw_spi_write(ADF4252_R6);
	adf4252_sw_spi_write(ADF4252_R3);
}

