#include "adf4106.h"
#include <msp430.h>
#include <inttypes.h>

void adf4106_sw_spi_write(uint32_t data) {
	int i = 24;
	
	ADF4106_LE_POUT &= ~ADF4106_LE;
	while (i-- > 0) {
		if ((data >> i) & 0x01) {
			ADF4106_DATA_POUT |= ADF4106_DATA;
		} else {
			ADF4106_DATA_POUT &= ~ADF4106_DATA;
		}
		ADF4106_CLK_POUT |= ADF4106_CLK;
		ADF4106_CLK_POUT &= ~ADF4106_CLK;
	}
	ADF4106_LE_POUT |= ADF4106_LE;
}

void adf4106_sw_spi_init(void) {
	ADF4106_LE_POUT |= ADF4106_LE;
	ADF4106_LE_PDIR |= ADF4106_LE;
	ADF4106_CLK_POUT &= ~ADF4106_CLK;
	ADF4106_CLK_PDIR |= ADF4106_CLK;
	ADF4106_DATA_POUT &= ~ADF4106_DATA;
	ADF4106_DATA_PDIR |= ADF4106_DATA;
}

void adf4106_config(void) {
	adf4106_sw_spi_init();

    __delay_cycles(10000);

	adf4106_sw_spi_write(ADF4106_R3);
	adf4106_sw_spi_write(ADF4106_R2 & ~ADF4106_PDP_POS);
	adf4106_sw_spi_write(ADF4106_R0);
	adf4106_sw_spi_write(ADF4106_R1_RX);

    __delay_cycles(10000);
    __delay_cycles(10000);
	adf4106_sw_spi_write(ADF4106_R2);
}

void adf4106_set_freq(int rx) {
	if (rx) {
		adf4106_sw_spi_write(ADF4106_R1_RX);
	} else {
		adf4106_sw_spi_write(ADF4106_R1_TX);
	}
}
