#ifndef ADF4106_H
#define ADF4106_H

#include <stdint.h>

void adf4106_config();
void adf4106_set_freq(int rx);

#define ADF4106_RF_TX_FREQ	2270000000UL
#define ADF4106_RF_RX_FREQ	2260000000UL
#define ADF4106_REF_FREQ	10000000UL
#define ADF4106_PFD_FREQ	10000000UL
#define ADF4106_RSET		5100
#define ADF4106_ICP		5.0e-3

#define ADF4106_R0_CB		0
#define ADF4106_R1_CB		1
#define ADF4106_R2_CB		2
#define ADF4106_R3_CB		3

/* Register 0
 * DB20		Lock Detect Precision
 * DB17:16	Anti Backslash Width
 * DB15:2	Reference Counter
 */

#define ADF4106_LDP_3		((unsigned long) 0 << 20)
#define ADF4106_LDP_5		((unsigned long) 1 << 20)

#define ADF4106_ABP2_9		((unsigned long) 0 << 16)
#define ADF4106_ABP1_3		((unsigned long) 1 << 16)
#define ADF4106_ABP6_0		((unsigned long) 2 << 16)

#define ADF4106_RDIV		((ADF4106_REF_FREQ / ADF4106_PFD_FREQ) << 2)

#define ADF4106_R0			(ADF4106_LDP_3 + ADF4106_ABP6_0 + ADF4106_RDIV + ADF4106_R0_CB)

/* Register 1
 * DB21		CP Gain
 * DB20:DB8	B Counter
 * DB7:DB2	A Counter
 */

#define ADF4106_CPG_1		((unsigned long) 0 << 21)
#define ADF4106_CPG_2		((unsigned long) 1 << 21)

#define ADF4106_N_TX		(ADF4106_RF_TX_FREQ / ADF4106_PFD_FREQ)
#define ADF4106_N_RX		(ADF4106_RF_RX_FREQ / ADF4106_PFD_FREQ)

#define ADF4106_PRE8		(ADF4106_RF_TX_FREQ <= 1600000000UL)
#define ADF4106_PRE16		(ADF4106_RF_TX_FREQ <= 3200000000UL)
#define ADF4106_PRE32		(ADF4106_RF_TX_FREQ <= 6400000000UL)
#define ADF4106_PRE64		(ADF4106_RF_TX_FREQ >  6400000000UL)

#define ADF4106_PRE			((ADF4106_PRE8) ? 8 : ((ADF4106_PRE16) ? 16 : ((ADF4106_PRE32) ? 32 : 64)))

#define ADF4106_B_TX_		(ADF4106_N_TX / ADF4106_PRE)
#define ADF4106_A_TX_		(ADF4106_N_TX - ADF4106_PRE * ADF4106_B_TX_)
#define ADF4106_B_RX_		(ADF4106_N_RX / ADF4106_PRE)
#define ADF4106_A_RX_		(ADF4106_N_RX - ADF4106_PRE * ADF4106_B_RX_)

#define ADF4106_A_TX		(ADF4106_A_TX_ << 2)
#define ADF4106_B_TX		(ADF4106_B_TX_ << 8)
#define ADF4106_A_RX		(ADF4106_A_RX_ << 2)
#define ADF4106_B_RX		(ADF4106_B_RX_ << 8)

#define ADF4106_R1_TX		(ADF4106_CPG_1 + ADF4106_B_TX + ADF4106_A_TX + ADF4106_R1_CB)
#define ADF4106_R1_RX		(ADF4106_CPG_1 + ADF4106_B_RX + ADF4106_A_RX + ADF4106_R1_CB)

/* Register 2
 * DB23:22  Prescaler Value
 * DB20:18	Current Setting 2
 * DB17:15  Current Setting 1
 * DB8      CP 3State
 * DB7      Phase Detector Polarity
 * DB6:4    MUXOUT Control
 * DB3      Power Down 1
 * DB2      Counter Reset
*/

#define ADF4106_ICP_MAX		(25.5/ADF4106_RSET)
#define ADF4106_CPI			((unsigned long) (ADF4106_ICP/ADF4106_ICP_MAX*8-0.5) << 15)
 
#define ADF4106_P			(((ADF4106_PRE8) ? (unsigned long) 0 : ((ADF4106_PRE16) ? (unsigned long) 1 : ((ADF4106_PRE32) ? (unsigned long) 2 : (unsigned long) 3))) << 22)

#define ADF4106_PD2_ASYNC	((unsigned long) 0 << 21)
#define ADF4106_PD2_SYNC	((unsigned long) 1 << 21)

#define ADF4106_PD1_NORMAL	(0 << 3)
#define ADF4106_PD1_PWRDN	(1 << 3)

#define ADF4106_TMR_CYCLES	3
#define ADF4106_TC			((ADF4106_TMR_CYCLES/4) << 11)

#define ADF4106_FL_OFF		(0 << 9)
#define ADF4106_FL_MODE1	(2 << 9)
#define ADF4106_FL_MODE2	(3 << 9)

#define ADF4106_CP_3ST_OFF	(0 << 8)
#define ADF4106_CP_3ST_ON	(1 << 8)

#define ADF4106_PDP_NEG		(0 << 7)
#define ADF4106_PDP_POS		(1 << 7)

#define ADF4106_MUX_3ST		(0 << 4)
#define ADF4106_MUX_DLD		(1 << 4)
#define ADF4106_MUX_NDIV	(2 << 4)
#define ADF4106_MUX_HI		(3 << 4)
#define ADF4106_MUX_RDIV	(4 << 4)
#define ADF4106_MUX_ALD		(5 << 4)
#define ADF4106_MUX_SDO		(6 << 4)
#define ADF4106_MUX_LOW		(7 << 4)

#define ADF4106_CNTRST_OFF	(0 << 2)
#define ADF4106_CNTRST_ON	(1 << 2)

#define ADF4106_R2			(ADF4106_P + ADF4106_CPI + ADF4106_PD1_NORMAL + ADF4106_FL_OFF + \
							ADF4106_CP_3ST_OFF + ADF4106_PDP_POS + ADF4106_MUX_DLD + ADF4106_R2_CB)

/* Register 3
 * same as R2
 */
#define ADF4106_R3			(ADF4106_P + ADF4106_CPI + ADF4106_PD1_NORMAL + ADF4106_FL_OFF + \
                            ADF4106_CP_3ST_OFF + ADF4106_PDP_POS + ADF4106_MUX_DLD + ADF4106_R3_CB)

/* pin mapping */
#define ADF4106_CLK			BIT7
#define ADF4106_CLK_POUT	P1OUT
#define ADF4106_CLK_PDIR	P1DIR
#define ADF4106_DATA		BIT6
#define ADF4106_DATA_POUT	P1OUT
#define ADF4106_DATA_PDIR	P1DIR
#define ADF4106_LE			BIT4
#define ADF4106_LE_POUT		P1OUT
#define ADF4106_LE_PDIR		P1DIR

#endif // ADF4106_H
