#ifndef ADF4360_H
#define ADF4360_H

#include <stdint.h>

void adf4360_config();
void adf4360_set_freq(int rx);

#define ADF4360_RF_TX_FREQ		2476000000UL
#define ADF4360_RF_RX_FREQ		1872000000UL
#define ADF4360_REF_FREQ	10000000UL
#define ADF4360_PFD_FREQ	2000000UL
#define ADF4360_RSET		4700
#define ADF4360_ICP			2.5e-3

#define ADF4360_R0_CB		0
#define ADF4360_R1_CB		1
#define ADF4360_R2_CB		2

/* Register 0
 * DB23:22 	Prescaler Value
 * DB21 	Power Down 2
 * DB20 	Power Down 1
 * DB19:17 	Current Setting 2
 * DB16:14 	Current Setting 1
 * DB13:12 	Output Power Level
 * DB11  	Mute till LD
 * DB10  	CP Gain
 * DB9  	CP Three-State
 * DB8  	Phase Detector Polarity
 * DB7:5	MUXOUT Control
 * DB4  	Counter Reset
 * DB3:2	Core Power Level
 */

/* TODO: check N to meet the P^2-P minimum division ratio requirement */
#define ADF4360_PRE8		(ADF4360_RF_TX_FREQ <= 2400000000UL)
#define ADF4360_PRE16		(ADF4360_RF_TX_FREQ <= 4800000000UL)
#define ADF4360_PRE32		(ADF4360_RF_TX_FREQ > 4800000000UL)
#define ADF4360_PRE			((ADF4360_PRE8) ? 8 : ((ADF4360_PRE16) ? 16 : 32))
#define ADF4360_P			(((ADF4360_PRE8) ? (unsigned long) 0 : ((ADF4360_PRE16) ? (unsigned long) 1 : (unsigned long) 2)) << 22)


#define ADF4360_PD2_ASYNC	((unsigned long) 0 << 21)
#define ADF4360_PD2_SYNC	((unsigned long) 1 << 21)

#define ADF4360_PD1_NORMAL	((unsigned long) 0 << 20)
#define ADF4360_PD1_PWRDN	((unsigned long) 1 << 20)

#define ADF4360_ICP_MAX		(11.75/ADF4360_RSET)
#define ADF4360_CPI			((unsigned long) (ADF4360_ICP/ADF4360_ICP_MAX*8-0.5) << 14)

#define ADF4360_PL_3		((unsigned long) 0 << 12)
#define ADF4360_PL_5		((unsigned long) 1 << 12)
#define ADF4360_PL_7		((unsigned long) 2 << 12)
#define ADF4360_PL_11		((unsigned long) 3 << 12)

#define ADF4360_MTLD_OFF	((unsigned long) 0 << 11)
#define ADF4360_MTLD_ON		((unsigned long) 1 << 11)

#define ADF4360_CPG_1		((unsigned long) 0 << 10)
#define ADF4360_CPG_2		((unsigned long) 1 << 10)

#define ADF4360_CP_3ST_OFF	((unsigned long) 0 << 9)
#define ADF4360_CP_3ST_ON	((unsigned long) 1 << 9)

#define ADF4360_PDP_NEG		((unsigned long) 0 << 8)
#define ADF4360_PDP_POS		((unsigned long) 1 << 8)

#define ADF4360_MUX_3ST		((unsigned long) 0 << 5)
#define ADF4360_MUX_DLD		((unsigned long) 1 << 5)
#define ADF4360_MUX_NDIV	((unsigned long) 2 << 5)
#define ADF4360_MUX_HI		((unsigned long) 3 << 5)
#define ADF4360_MUX_RDIV	((unsigned long) 4 << 5)
#define ADF4360_MUX_ALD		((unsigned long) 5 << 5)
#define ADF4360_MUX_SDO		((unsigned long) 6 << 5)
#define ADF4360_MUX_LOW		((unsigned long) 7 << 5)

#define ADF4360_CNTRST_OFF	(0 << 4)
#define ADF4360_CNTRST_ON	(1 << 4)

#define ADF4360_COREPWR_5	(0 << 2)
#define ADF4360_COREPWR_10	(1 << 2)
#define ADF4360_COREPWR_15	(2 << 2)
#define ADF4360_COREPWR_20	(3 << 2)

#define ADF4360_R0			(ADF4360_P + ADF4360_PD1_NORMAL + ADF4360_CPI + ADF4360_PL_11 + ADF4360_MTLD_ON + ADF4360_CPG_1 + \
							 ADF4360_CP_3ST_OFF + ADF4360_PDP_POS + ADF4360_MUX_DLD + ADF4360_CNTRST_OFF + ADF4360_COREPWR_15 + ADF4360_R0_CB)

/* Register 2
 * DB23		Dvidide-by-2 Select
 * DB22		Divide-by-2
 * DB21		Fast Lock CP Gain
 * DB20:DB8	B Counter
 * DB6:DB2	A Counter
 */

#define ADF4360_DIVSEL_FUND	((unsigned long) 0 << 23)
#define ADF4360_DIVSEL_BY2	((unsigned long) 1 << 23)

#define ADF4360_DIV2_FUND	((unsigned long) 0 << 22)
#define ADF4360_DIV2_BY2	((unsigned long) 1 << 22)

#define ADF4360_FL_CPG_1	((unsigned long) 0 << 21)
#define ADF4360_FL_CPG_2	((unsigned long) 0 << 21)

#define ADF4360_N_TX		(ADF4360_RF_TX_FREQ / ADF4360_PFD_FREQ)
#define ADF4360_B_TX_		(ADF4360_N_TX / ADF4360_PRE)
#define ADF4360_A_TX_		(ADF4360_N_TX - ADF4360_PRE * ADF4360_B_TX_)
#define ADF4360_N_RX		(ADF4360_RF_RX_FREQ / ADF4360_PFD_FREQ)
#define ADF4360_B_RX_		(ADF4360_N_RX / ADF4360_PRE)
#define ADF4360_A_RX_		(ADF4360_N_RX - ADF4360_PRE * ADF4360_B_RX_)

#define ADF4360_B_TX		(ADF4360_B_TX_ << 8)
#define ADF4360_A_TX		(ADF4360_A_TX_ << 2)
#define ADF4360_B_RX		(ADF4360_B_RX_ << 8)
#define ADF4360_A_RX		(ADF4360_A_RX_ << 2)

#define ADF4360_R2_TX		(ADF4360_DIVSEL_FUND + ADF4360_DIV2_FUND + ADF4360_FL_CPG_1 + ADF4360_B_TX + ADF4360_A_TX + ADF4360_R2_CB)
#define ADF4360_R2_RX		(ADF4360_DIVSEL_FUND + ADF4360_DIV2_FUND + ADF4360_FL_CPG_1 + ADF4360_B_RX + ADF4360_A_RX + ADF4360_R2_CB)

/* Register 1
 * DB21:20	Band Select Clock
 * DB18		Lock Detect Precision
 * DB17:16	Anti-Backlash Pulse Width
 * DB15:2	Reference Counter
 */

#define ADF4360_BSC2		(ADF4360_PFD_FREQ > 1000000UL)
#define ADF4360_BSC4		(ADF4360_PFD_FREQ > 4000000UL)
#define ADF4360_BSC8		(ADF4360_PFD_FREQ > 8000000UL)
#define ADF4360_BSC			((ADF4360_BSC8) ? (unsigned long) 3 : ((ADF4360_BSC4) ? (unsigned long) 2 : ((ADF4360_BSC2) ? (unsigned long) 1 : 0)) << 20)

#define ADF4360_LDP_3		((unsigned long) 0 << 18)
#define ADF4360_LDP_5		((unsigned long) 1 << 18)

#define ADF4360_ABP1		((unsigned long) 1 << 16)
#define ADF4360_ABP3		((unsigned long) 0 << 16)
#define ADF4360_ABP6		((unsigned long) 2 << 16)

#define ADF4360_RDIV		((ADF4360_REF_FREQ / ADF4360_PFD_FREQ) << 2)

#define ADF4360_R1			(ADF4360_BSC + ADF4360_LDP_5 + ADF4360_ABP3 + \
							ADF4360_RDIV + ADF4360_R1_CB)

/* pin mapping */
#define ADF4360_CLK			BIT7
#define ADF4360_CLK_POUT	P1OUT
#define ADF4360_CLK_PDIR	P1DIR
#define ADF4360_DATA		BIT6
#define ADF4360_DATA_POUT	P1OUT
#define ADF4360_DATA_PDIR	P1DIR
#define ADF4360_LE			BIT4
#define ADF4360_LE_POUT		P2OUT
#define ADF4360_LE_PDIR		P2DIR

#endif // ADF4360_H
