#include "adf4001.h"
#include <msp430.h>
#include <inttypes.h>

void adf4001_sw_spi_write(uint32_t data) {
	int i = 24;
	
	ADF4001_LE_POUT &= ~ADF4001_LE;
	while (i-- > 0) {
		if ((data >> i) & 0x01) {
			ADF4001_DATA_POUT |= ADF4001_DATA;
		} else {
			ADF4001_DATA_POUT &= ~ADF4001_DATA;
		}
		ADF4001_CLK_POUT |= ADF4001_CLK;
		ADF4001_CLK_POUT &= ~ADF4001_CLK;
	}
	ADF4001_LE_POUT |= ADF4001_LE;
}

void adf4001_sw_spi_init(void) {
	ADF4001_LE_POUT |= ADF4001_LE;
	ADF4001_LE_PDIR |= ADF4001_LE;
	ADF4001_CLK_POUT &= ~ADF4001_CLK;
	ADF4001_CLK_PDIR |= ADF4001_CLK;
	ADF4001_DATA_POUT &= ~ADF4001_DATA;
	ADF4001_DATA_PDIR |= ADF4001_DATA;
}

void adf4001_config(void) {
	ADF4001_CE_POUT |= ADF4001_CE;
	ADF4001_CE_PDIR |= ADF4001_CE;
    
	adf4001_sw_spi_init();

    __delay_cycles(10000);

	adf4001_sw_spi_write(ADF4001_R3);
	adf4001_sw_spi_write(ADF4001_R2);
	adf4001_sw_spi_write(ADF4001_R0);
	adf4001_sw_spi_write(ADF4001_R1);
}

