/*
 * 10 GHz transverter sequencer software
 */

#include <msp430.h>
#include "main.h"

/*
 * waitms
 *
 * delay loop, calibrated to about 1 ms
 * cpu clock ~700 kHz, minimum count is ~700 cycles 
 */
void waitms(int ms) {
	volatile int i;
	volatile int ms_cd = ms;

	while(ms_cd-- > 0) {
		for (i = MS_DELAY_VALUE; i > 0; i--);
	}
}

/*
 * hw_init
 *
 * initializes I/Os to a safe state after power up
 */
void hw_init(void) {
	/* enable PTT input pullup voltage */
	PTT_VPU_POUT |= PTT_VPU;
	PTT_VPU_PDIR |= PTT_VPU;

	/* make the PTT pin an input */
	PTT_IN_PDIR &= ~PTT_IN;

	/* inhibit TX */
	TX_ALLOW_POUT &= ~TX_ALLOW;
	TX_ALLOW_PDIR |= TX_ALLOW;

	TX_PA_12V_POUT &= ~TX_PA_12V;
	TX_PA_12V_PDIR |= TX_PA_12V;
		
	/* disable voltage for TX */
	TX_8V_POUT &= ~TX_8V;
	TX_8V_PDIR |= TX_8V;

	/* disable voltage for RX */
	RX_8V_POUT &= ~RX_8V;
	RX_8V_PDIR |= RX_8V;

	/* set relay pins output, do not switch yet */	
	RLY_TX_POUT &= ~RLY_TX;
	RLY_TX_PDIR |= RLY_TX;

	RLY_RX_POUT &= ~RLY_RX;
	RLY_RX_PDIR |= RLY_RX;

}

int main(void) {
	enum {SEQ_INIT, SEQ_RX, SEQ_TX};
	int sequencer_state = SEQ_INIT;

	WDTCTL = WDTPW + WDTHOLD;
	
	hw_init();
	sequencer_state = SEQ_INIT;
	while(1) {
		/* transition to RX */
		if ((sequencer_state != SEQ_RX) && !(PTT_IN_PIN & PTT_IN)) {
			TX_ALLOW_POUT &= ~TX_ALLOW;
			TX_PA_12V_POUT &= ~TX_PA_12V;
			TX_8V_POUT &= ~TX_8V;
			waitms(10);
			RLY_RX_POUT |= RLY_RX;
			waitms(10);
			RLY_RX_POUT &= ~RLY_RX;
			RX_8V_POUT |= RX_8V;
			sequencer_state = SEQ_RX;
		}
	
		/* transition to TX */
		if ((sequencer_state != SEQ_TX) && (PTT_IN_PIN & PTT_IN)) {
			RX_8V_POUT &= ~RX_8V;
			RLY_TX_POUT |= RLY_TX;
			waitms(10);
			RLY_TX_POUT &= ~RLY_TX;
			TX_8V_POUT |= TX_8V;
			TX_PA_12V_POUT |= TX_PA_12V;
			TX_ALLOW_POUT |= TX_ALLOW;
			sequencer_state = SEQ_TX;
		}
	}

}
