#ifndef ADF4001_H
#define ADF4001_H

#include <stdint.h>

void adf4001_config();

#define LE		BIT2
#define DAT		BIT3
#define CLK		BIT4

#define ADF4001_RF_FREQ		10000000UL
#define ADF4001_REF_FREQ	10000UL
#define ADF4001_PFD_FREQ	10000UL
#define ADF4001_RSET		4700
#define ADF4001_ICP			5.00e-3

#define ADF4001_R0_CB		0
#define ADF4001_R1_CB		1
#define ADF4001_R2_CB		2
#define ADF4001_R3_CB		3

/* Register 0
 * DB20		Lock Detect Precision
 * DB17:16	Anti Backslash Width
 * DB15:2	Reference Counter
 */

#define ADF4001_LDP_3		((unsigned long) 0 << 20)
#define ADF4001_LDP_5		((unsigned long) 1 << 20)

#define ADF4001_ABP2_9		((unsigned long) 0 << 16)
#define ADF4001_ABP1_3		((unsigned long) 1 << 16)
#define ADF4001_ABP6_0		((unsigned long) 2 << 16)

#define ADF4001_RDIV		((ADF4001_REF_FREQ / ADF4001_PFD_FREQ) << 2)

#define ADF4001_R0			(ADF4001_LDP_3 + ADF4001_ABP6_0 + ADF4001_RDIV + ADF4001_R0_CB)

/* Register 1
 * DB21		CP Gain
 * DB20:DB8	N Counter
 */

#define ADF4001_CPG_1		((unsigned long) 0 << 21)
#define ADF4001_CPG_2		((unsigned long) 1 << 21)

#define ADF4001_N			((ADF4001_RF_FREQ / ADF4001_PFD_FREQ) << 8)

#define ADF4001_R1			(ADF4001_CPG_1 + ADF4001_N + ADF4001_R1_CB)

/* Register 2
 * DB21		Power Down 2
 * DB20:18	Current Setting 2
 * DB17:15	Current Setting 1
 * DB14:11	Timer Counter Control
 * DB10		Fast Lock Mode
 * DB9		Fast Lock Enable
 * DB8		CP 3State
 * DB7		Phase Detector Polarity
 * DB6:4	MUXOUT Control
 * DB3		Power Down 1
 * DB2		Counter Reset
 */

#define ADF4001_ICP_MAX		(23.5/ADF4001_RSET)
#define ADF4001_CPI			((unsigned long) (ADF4001_ICP/ADF4001_ICP_MAX*8-0.5) << 15)

#define ADF4001_PD2_ASYNC	((unsigned long) 0 << 21)
#define ADF4001_PD2_SYNC	((unsigned long) 1 << 21)

#define ADF4001_PD1_NORMAL	(0 << 3)
#define ADF4001_PD1_PWRDN	(1 << 3)

#define ADF4001_TMR_CYCLES	3
#define ADF4001_TC			((ADF4001_TMR_CYCLES/4) << 11)

#define ADF4001_FL_OFF		(0 << 9)
#define ADF4001_FL_MODE1	(2 << 9)
#define ADF4001_FL_MODE2	(3 << 9)

#define ADF4001_CP_3ST_OFF	(0 << 8)
#define ADF4001_CP_3ST_ON	(1 << 8)

#define ADF4001_PDP_NEG		(0 << 7)
#define ADF4001_PDP_POS		(1 << 7)

#define ADF4001_MUX_3ST		(0 << 4)
#define ADF4001_MUX_DLD		(1 << 4)
#define ADF4001_MUX_NDIV	(2 << 4)
#define ADF4001_MUX_HI		(3 << 4)
#define ADF4001_MUX_RDIV	(4 << 4)
#define ADF4001_MUX_ALD		(5 << 4)
#define ADF4001_MUX_SDO		(6 << 4)
#define ADF4001_MUX_LOW		(7 << 4)

#define ADF4001_CNTRST_OFF	(0 << 2)
#define ADF4001_CNTRST_ON	(1 << 2)

#define ADF4001_R2			(ADF4001_CPI + ADF4001_PD1_NORMAL + ADF4001_FL_OFF + \
							ADF4001_CP_3ST_OFF + ADF4001_PDP_POS + ADF4001_MUX_DLD + ADF4001_R2_CB)

/* Register 3
 * same as R2
 */
#define ADF4001_R3			(ADF4001_CPI + ADF4001_PD1_NORMAL + ADF4001_FL_OFF + \
                            ADF4001_CP_3ST_OFF + ADF4001_PDP_POS + ADF4001_MUX_DLD + ADF4001_R3_CB)

/* pin mapping */
#define ADF4001_CLK		0x20
#define ADF4001_CLK_POUT	P1OUT
#define ADF4001_CLK_PDIR	P1DIR
#define ADF4001_DATA		0x10
#define ADF4001_DATA_POUT	P1OUT
#define ADF4001_DATA_PDIR	P1DIR
#define ADF4001_LE		0x08
#define ADF4001_LE_POUT		P1OUT
#define ADF4001_LE_PDIR		P1DIR

#endif // ADF4001_H
