
main.elf:     file format elf32-msp430


Disassembly of section .text:

0000f800 <__watchdog_support>:
    f800:	55 42 20 01 	mov.b	&0x0120,r5	
    f804:	35 d0 08 5a 	bis	#23048,	r5	;#0x5a08
    f808:	82 45 78 02 	mov	r5,	&0x0278	

0000f80c <__init_stack>:
    f80c:	31 40 80 02 	mov	#640,	r1	;#0x0280

0000f810 <__do_copy_data>:
    f810:	3f 40 70 00 	mov	#112,	r15	;#0x0070
    f814:	0f 93       	tst	r15		
    f816:	08 24       	jz	$+18     	;abs 0xf828
    f818:	92 42 78 02 	mov	&0x0278,&0x0120	
    f81c:	20 01 
    f81e:	2f 83       	decd	r15		
    f820:	9f 4f f4 fc 	mov	-780(r15),512(r15);0xfcf4(r15), 0x0200(r15)
    f824:	00 02 
    f826:	f8 23       	jnz	$-14     	;abs 0xf818

0000f828 <__do_clear_bss>:
    f828:	3f 40 08 00 	mov	#8,	r15	;#0x0008
    f82c:	0f 93       	tst	r15		
    f82e:	07 24       	jz	$+16     	;abs 0xf83e
    f830:	92 42 78 02 	mov	&0x0278,&0x0120	
    f834:	20 01 
    f836:	1f 83       	dec	r15		
    f838:	cf 43 70 02 	mov.b	#0,	624(r15);r3 As==00, 0x0270(r15)
    f83c:	f9 23       	jnz	$-12     	;abs 0xf830

0000f83e <main>:

/*
 * main.c
 */
int main(void) {
	WDTCTL = WDTPW | WDTHOLD;	// Stop watchdog timer
    f83e:	b2 40 80 5a 	mov	#23168,	&0x0120	;#0x5a80
    f842:	20 01 
	uart_init();
    f844:	b0 12 7c f8 	call	#0xf87c	
	gps_startup_delay();
    f848:	b0 12 7e f9 	call	#0xf97e	
	
	gps_disable_nmea_output();
    f84c:	b0 12 fc f8 	call	#0xf8fc	
	gps_startup_delay();
    f850:	b0 12 7e f9 	call	#0xf97e	
	gps_set_gps_only();
    f854:	b0 12 1e f9 	call	#0xf91e	
	gps_startup_delay();
    f858:	b0 12 7e f9 	call	#0xf97e	
	gps_enable_timepulse();
    f85c:	b0 12 40 f9 	call	#0xf940	
	gps_startup_delay();
    f860:	b0 12 7e f9 	call	#0xf97e	

	adf4001_config();
    f864:	b0 12 d2 fb 	call	#0xfbd2	
	adf4113_config();
    f868:	b0 12 32 fb 	call	#0xfb32	

	__bis_SR_register(LPM3_bits);
    f86c:	32 d0 d0 00 	bis	#208,	r2	;#0x00d0
    f870:	ff 3f       	jmp	$+0      	;abs 0xf870

0000f872 <__stop_progExec__>:
    f872:	32 d0 f0 00 	bis	#240,	r2	;#0x00f0
    f876:	fd 3f       	jmp	$-4      	;abs 0xf872

0000f878 <__ctors_end>:
    f878:	30 40 f2 fc 	br	#0xfcf2	

0000f87c <uart_init>:
extern unsigned int RXTXData;
extern unsigned char BitCnt;


void uart_init(void) {
	UART_TX_POUT |= UART_TX;
    f87c:	e2 d3 21 00 	bis.b	#2,	&0x0021	;r3 As==10
	UART_TX_PDIR |= UART_TX;
    f880:	e2 d3 22 00 	bis.b	#2,	&0x0022	;r3 As==10
	UART_TX_PSEL |= UART_TX;
    f884:	e2 d3 26 00 	bis.b	#2,	&0x0026	;r3 As==10
  	BCSCTL1 |= DIVA_3;                        // ACLK = LFXT1CLK/8
    f888:	f2 d0 30 00 	bis.b	#48,	&0x0057	;#0x0030
    f88c:	57 00 
  	CCTL0 = OUT;                              // TXD Idle as Mark
    f88e:	a2 42 62 01 	mov	#4,	&0x0162	;r2 As==10
  	CCTL2 = CM_1 + CCIS_1 + CAP + CCIE;       // CAP, ACLK, interrupt
    f892:	b2 40 10 51 	mov	#20752,	&0x0166	;#0x5110
    f896:	66 01 
  	TACTL = TASSEL_2 + MC_2;                  // SMCLK, continuous mode
    f898:	b2 40 20 02 	mov	#544,	&0x0160	;#0x0220
    f89c:	60 01 
	__nop();
    f89e:	03 43       	nop			
	__bis_SR_register(GIE);
    f8a0:	32 d2       	eint			
	__nop();
    f8a2:	03 43       	nop			
}
    f8a4:	30 41       	ret			

0000f8a6 <uart_tx_byte>:

inline void uart_tx_byte(uint8_t tx) {
	RXTXData = tx;
  	BitCnt = 0xA;                             // Load Bit counter, 8data + ST/SP
    f8a6:	f2 40 0a 00 	mov.b	#10,	&0x0272	;#0x000a
    f8aa:	72 02 
  	CCR0 = TAR;                               // Current state of TA counter
    f8ac:	92 42 70 01 	mov	&0x0170,&0x0172	
    f8b0:	72 01 
  	CCR0 += Bitime;                           // Some time till first bit
    f8b2:	b2 50 d0 00 	add	#208,	&0x0172	;#0x00d0
    f8b6:	72 01 
	__bis_SR_register(GIE);
	__nop();
}

inline void uart_tx_byte(uint8_t tx) {
	RXTXData = tx;
    f8b8:	4f 4f       	mov.b	r15,	r15	
  	BitCnt = 0xA;                             // Load Bit counter, 8data + ST/SP
  	CCR0 = TAR;                               // Current state of TA counter
  	CCR0 += Bitime;                           // Some time till first bit
  	RXTXData |= 0x100;                        // Add mark stop bit to RXTXData
  	RXTXData = RXTXData << 1;                 // Add space start bit
    f8ba:	3f d0 00 01 	bis	#256,	r15	;#0x0100
    f8be:	82 4f 70 02 	mov	r15,	&0x0270	
    f8c2:	92 52 70 02 	rla	&0x0270	
    f8c6:	70 02 
  	CCTL0 = OUTMOD0 + CCIE;                   // TXD = mark = idle
    f8c8:	b2 40 30 00 	mov	#48,	&0x0162	;#0x0030
    f8cc:	62 01 
  	while ( CCTL0 & CCIE );                   // Wait for TX completion
    f8ce:	b2 b0 10 00 	bit	#16,	&0x0162	;#0x0010
    f8d2:	62 01 
    f8d4:	fc 23       	jnz	$-6      	;abs 0xf8ce
}
    f8d6:	30 41       	ret			

0000f8d8 <gps_transmit_string>:
/* 
 * gps_transmit_string
 *
 * transmits a command to the GPS
 */
void gps_transmit_string(char *cmd, uint8_t length) {
    f8d8:	0b 12       	push	r11		
    f8da:	0a 12       	push	r10		
    f8dc:	09 12       	push	r9		
    f8de:	0a 4f       	mov	r15,	r10	
    f8e0:	49 4e       	mov.b	r14,	r9	
	uint8_t i;

	for (i = 0; i < length; i++) {
    f8e2:	0b 4f       	mov	r15,	r11	
    f8e4:	03 3c       	jmp	$+8      	;abs 0xf8ec
		uart_tx_byte(cmd[i]);
    f8e6:	7f 4b       	mov.b	@r11+,	r15	
    f8e8:	b0 12 a6 f8 	call	#0xf8a6	
 * transmits a command to the GPS
 */
void gps_transmit_string(char *cmd, uint8_t length) {
	uint8_t i;

	for (i = 0; i < length; i++) {
    f8ec:	4f 4b       	mov.b	r11,	r15	
    f8ee:	4f 8a       	sub.b	r10,	r15	
    f8f0:	4f 99       	cmp.b	r9,	r15	
    f8f2:	f9 2b       	jnc	$-12     	;abs 0xf8e6
		uart_tx_byte(cmd[i]);
	}
}
    f8f4:	39 41       	pop	r9		
    f8f6:	3a 41       	pop	r10		
    f8f8:	3b 41       	pop	r11		
    f8fa:	30 41       	ret			

0000f8fc <gps_disable_nmea_output>:
 * may save power to disable them completely.
 *
 * returns if ACKed by GPS
 *
 */
void gps_disable_nmea_output(void) {
    f8fc:	31 50 e4 ff 	add	#-28,	r1	;#0xffe4
	char nonmea[] = {
    f900:	3d 40 1c 00 	mov	#28,	r13	;#0x001c
    f904:	3e 40 00 02 	mov	#512,	r14	;#0x0200
    f908:	0f 41       	mov	r1,	r15	
    f90a:	b0 12 f8 fb 	call	#0xfbf8	
		0x00, 0x00,					/* flags */
		0x00, 0x00,					/* reserved */
		0xaa, 0x79					/* checksum */
	};

	gps_transmit_string(nonmea, sizeof(nonmea));
    f90e:	7e 40 1c 00 	mov.b	#28,	r14	;#0x001c
    f912:	0f 41       	mov	r1,	r15	
    f914:	b0 12 d8 f8 	call	#0xf8d8	
	return;
}
    f918:	31 50 1c 00 	add	#28,	r1	;#0x001c
    f91c:	30 41       	ret			

0000f91e <gps_set_gps_only>:
 * tells the uBlox to only use the GPS satellites
 *
 * returns if ACKed by GPS
 *
 */
void gps_set_gps_only(void) {
    f91e:	31 50 d4 ff 	add	#-44,	r1	;#0xffd4
	char gpsonly[] = {
    f922:	3d 40 2c 00 	mov	#44,	r13	;#0x002c
    f926:	3e 40 1c 02 	mov	#540,	r14	;#0x021c
    f92a:	0f 41       	mov	r1,	r15	
    f92c:	b0 12 f8 fb 	call	#0xfbf8	
		0x05, 0, 0, 0, 0x00, 0x00, 0x00, 0x00,		/* QZSS disable, 0 channels */
		0x06, 0, 0, 0, 0x00, 0x00, 0x00, 0x00,		/* GLONASS disable, 0 channels */
		0xeb, 0x72					/* checksum */
	};

	gps_transmit_string(gpsonly, sizeof(gpsonly));
    f930:	7e 40 2c 00 	mov.b	#44,	r14	;#0x002c
    f934:	0f 41       	mov	r1,	r15	
    f936:	b0 12 d8 f8 	call	#0xf8d8	
	return;
}
    f93a:	31 50 2c 00 	add	#44,	r1	;#0x002c
    f93e:	30 41       	ret			

0000f940 <gps_enable_timepulse>:
#define TP_PERIOD	1000000UL
#define TP_LEN		500000UL
#define TP_PERIOD_LOCKED	100UL
#define TP_LEN_LOCKED		50UL

void gps_enable_timepulse(void) {
    f940:	31 50 d8 ff 	add	#-40,	r1	;#0xffd8
	int i;
	char timepulse[40] = {
    f944:	3d 40 28 00 	mov	#40,	r13	;#0x0028
    f948:	3e 40 48 02 	mov	#584,	r14	;#0x0248
    f94c:	0f 41       	mov	r1,	r15	
    f94e:	b0 12 f8 fb 	call	#0xfbf8	
		0x00, 0x00, 0x00, 0x00,			/* no user delay */
		0b00010111, 0x00, 0x00, 0x00,		/* enable TP, lock to GNSS, setting is length */
		0x00, 0x00				/* placeholder for checksum */
	};

	for (i = 2; i < sizeof(timepulse)-2; i++) {
    f952:	2f 43       	mov	#2,	r15	;r3 As==10
#define TP_PERIOD	1000000UL
#define TP_LEN		500000UL
#define TP_PERIOD_LOCKED	100UL
#define TP_LEN_LOCKED		50UL

void gps_enable_timepulse(void) {
    f954:	0e 41       	mov	r1,	r14	
    f956:	0e 5f       	add	r15,	r14	
		0b00010111, 0x00, 0x00, 0x00,		/* enable TP, lock to GNSS, setting is length */
		0x00, 0x00				/* placeholder for checksum */
	};

	for (i = 2; i < sizeof(timepulse)-2; i++) {
		timepulse[38] += timepulse[i];		
    f958:	6e 4e       	mov.b	@r14,	r14	
    f95a:	5e 51 26 00 	add.b	38(r1),	r14	;0x0026(r1)
    f95e:	c1 4e 26 00 	mov.b	r14,	38(r1)	;0x0026(r1)
		timepulse[39] += timepulse[38];
    f962:	c1 5e 27 00 	add.b	r14,	39(r1)	;0x0027(r1)
		0x00, 0x00, 0x00, 0x00,			/* no user delay */
		0b00010111, 0x00, 0x00, 0x00,		/* enable TP, lock to GNSS, setting is length */
		0x00, 0x00				/* placeholder for checksum */
	};

	for (i = 2; i < sizeof(timepulse)-2; i++) {
    f966:	1f 53       	inc	r15		
    f968:	3f 90 26 00 	cmp	#38,	r15	;#0x0026
    f96c:	f3 23       	jnz	$-24     	;abs 0xf954
		timepulse[38] += timepulse[i];		
		timepulse[39] += timepulse[38];
	}

	gps_transmit_string(timepulse, sizeof(timepulse));
    f96e:	7e 40 28 00 	mov.b	#40,	r14	;#0x0028
    f972:	0f 41       	mov	r1,	r15	
    f974:	b0 12 d8 f8 	call	#0xf8d8	

	return;
}
    f978:	31 50 28 00 	add	#40,	r1	;#0x0028
    f97c:	30 41       	ret			

0000f97e <gps_startup_delay>:
 * waits for the GPS to start up. this value is empirical.
 * we could also wait for the startup string
 */
void gps_startup_delay(void) {
	/* wait for the GPS to startup */
	__delay_cycles(60000);
    f97e:	3f 40 1f 4e 	mov	#19999,	r15	;#0x4e1f
    f982:	1f 83       	dec	r15		
    f984:	fe 23       	jnz	$-2      	;abs 0xf982
    f986:	03 43       	nop			
	__delay_cycles(60000);
    f988:	3f 40 1f 4e 	mov	#19999,	r15	;#0x4e1f
    f98c:	1f 83       	dec	r15		
    f98e:	fe 23       	jnz	$-2      	;abs 0xf98c
    f990:	03 43       	nop			
	__delay_cycles(60000);
    f992:	3f 40 1f 4e 	mov	#19999,	r15	;#0x4e1f
    f996:	1f 83       	dec	r15		
    f998:	fe 23       	jnz	$-2      	;abs 0xf996
    f99a:	03 43       	nop			
	__delay_cycles(60000);
    f99c:	3f 40 1f 4e 	mov	#19999,	r15	;#0x4e1f
    f9a0:	1f 83       	dec	r15		
    f9a2:	fe 23       	jnz	$-2      	;abs 0xf9a0
    f9a4:	03 43       	nop			
	__delay_cycles(60000);
    f9a6:	3f 40 1f 4e 	mov	#19999,	r15	;#0x4e1f
    f9aa:	1f 83       	dec	r15		
    f9ac:	fe 23       	jnz	$-2      	;abs 0xf9aa
    f9ae:	03 43       	nop			
	__delay_cycles(60000);
    f9b0:	3f 40 1f 4e 	mov	#19999,	r15	;#0x4e1f
    f9b4:	1f 83       	dec	r15		
    f9b6:	fe 23       	jnz	$-2      	;abs 0xf9b4
    f9b8:	03 43       	nop			
	__delay_cycles(60000);
    f9ba:	3f 40 1f 4e 	mov	#19999,	r15	;#0x4e1f
    f9be:	1f 83       	dec	r15		
    f9c0:	fe 23       	jnz	$-2      	;abs 0xf9be
    f9c2:	03 43       	nop			
	__delay_cycles(60000);
    f9c4:	3f 40 1f 4e 	mov	#19999,	r15	;#0x4e1f
    f9c8:	1f 83       	dec	r15		
    f9ca:	fe 23       	jnz	$-2      	;abs 0xf9c8
    f9cc:	03 43       	nop			
	__delay_cycles(60000);
    f9ce:	3f 40 1f 4e 	mov	#19999,	r15	;#0x4e1f
    f9d2:	1f 83       	dec	r15		
    f9d4:	fe 23       	jnz	$-2      	;abs 0xf9d2
    f9d6:	03 43       	nop			
	__delay_cycles(60000);
    f9d8:	3f 40 1f 4e 	mov	#19999,	r15	;#0x4e1f
    f9dc:	1f 83       	dec	r15		
    f9de:	fe 23       	jnz	$-2      	;abs 0xf9dc
    f9e0:	03 43       	nop			
	__delay_cycles(60000);
    f9e2:	3f 40 1f 4e 	mov	#19999,	r15	;#0x4e1f
    f9e6:	1f 83       	dec	r15		
    f9e8:	fe 23       	jnz	$-2      	;abs 0xf9e6
    f9ea:	03 43       	nop			
	__delay_cycles(60000);
    f9ec:	3f 40 1f 4e 	mov	#19999,	r15	;#0x4e1f
    f9f0:	1f 83       	dec	r15		
    f9f2:	fe 23       	jnz	$-2      	;abs 0xf9f0
    f9f4:	03 43       	nop			
}
    f9f6:	30 41       	ret			

0000f9f8 <Timer_A0>:
#elif defined(__GNUC__)
void __attribute__ ((interrupt(TIMERA0_VECTOR))) Timer_A0 (void)
#else
#error Compiler not supported!
#endif
{
    f9f8:	0f 12       	push	r15		
    f9fa:	0e 12       	push	r14		
    f9fc:	0d 12       	push	r13		
  CCR0 += Bitime;                           // Add Offset to CCR0
    f9fe:	b2 50 d0 00 	add	#208,	&0x0172	;#0x00d0
    fa02:	72 01 

  if (CCTL0 & CCIS0)                        // RX on CCI0B?
    fa04:	1f 42 62 01 	mov	&0x0162,r15	
    fa08:	3f b0 00 10 	bit	#4096,	r15	;#0x1000
    fa0c:	1e 20       	jnz	$+62     	;abs 0xfa4a
	  /* RX */
  }
  else
  {
    /* TX */
    if ( BitCnt == 0)
    fa0e:	5e 42 72 02 	mov.b	&0x0272,r14	
    CCTL0 &= ~ CCIE;                        // All bits TXed, disable interrupt
    fa12:	1f 42 62 01 	mov	&0x0162,r15	
	  /* RX */
  }
  else
  {
    /* TX */
    if ( BitCnt == 0)
    fa16:	4e 93       	tst.b	r14		
    fa18:	05 20       	jnz	$+12     	;abs 0xfa24
    CCTL0 &= ~ CCIE;                        // All bits TXed, disable interrupt
    fa1a:	3f f0 ef ff 	and	#-17,	r15	;#0xffef
    fa1e:	82 4f 62 01 	mov	r15,	&0x0162	
    fa22:	13 3c       	jmp	$+40     	;abs 0xfa4a
    else
    {
      CCTL0 |=  OUTMOD2;                    // TX Space
    fa24:	3f d0 80 00 	bis	#128,	r15	;#0x0080
    fa28:	82 4f 62 01 	mov	r15,	&0x0162	
      if (RXTXData & 0x01)
    fa2c:	1d 42 70 02 	mov	&0x0270,r13	
    fa30:	1d b3       	bit	#1,	r13	;r3 As==01
    fa32:	03 24       	jz	$+8      	;abs 0xfa3a
      CCTL0 &= ~ OUTMOD2;                   // TX Mark
    fa34:	b2 f0 7f ff 	and	#-129,	&0x0162	;#0xff7f
    fa38:	62 01 
      RXTXData = RXTXData >> 1;
    fa3a:	82 4d 70 02 	mov	r13,	&0x0270	
    fa3e:	12 c3       	clrc			
    fa40:	12 10 70 02 	rrc	&0x0270	
      BitCnt --;
    fa44:	7e 53       	add.b	#-1,	r14	;r3 As==11
    fa46:	c2 4e 72 02 	mov.b	r14,	&0x0272	
    }
  }
}
    fa4a:	3d 41       	pop	r13		
    fa4c:	3e 41       	pop	r14		
    fa4e:	3f 41       	pop	r15		
    fa50:	00 13       	reti			

0000fa52 <Timer_A1>:
#elif defined(__GNUC__)
void __attribute__ ((interrupt(TIMERA1_VECTOR))) Timer_A1 (void)
#else
#error Compiler not supported!
#endif
{
    fa52:	0f 12       	push	r15		
    fa54:	0e 12       	push	r14		
  switch( TAIV )
    fa56:	1f 42 2e 01 	mov	&0x012e,r15	
    fa5a:	2f 92       	cmp	#4,	r15	;r2 As==10
    fa5c:	2b 20       	jnz	$+88     	;abs 0xfab4
  {
    case  2: break;                         // CCR1 not used
    case  4:
    {
    Compare = CCR2;                         // Get current captured SMCLK
    fa5e:	1f 42 76 01 	mov	&0x0176,r15	
    Compare = Compare - Oldcapture;         // SMCLK difference
    fa62:	1f 82 74 02 	sub	&0x0274,r15	
    fa66:	82 4f 76 02 	mov	r15,	&0x0276	
    Oldcapture = CCR2;                      // Save current captured SMCLK
    fa6a:	92 42 76 01 	mov	&0x0176,&0x0274	
    fa6e:	74 02 
    if (DELTA < Compare)
    fa70:	3f 90 e9 01 	cmp	#489,	r15	;#0x01e9
    fa74:	0f 28       	jnc	$+32     	;abs 0xfa94
      {
        DCOCTL--;
    fa76:	f2 53 56 00 	add.b	#-1,	&0x0056	;r3 As==11
        if (DCOCTL == 0xFF)                 // DCO is too fast, slow it down
    fa7a:	5f 42 56 00 	mov.b	&0x0056,r15	
    fa7e:	7f 93       	cmp.b	#-1,	r15	;r3 As==11
    fa80:	19 20       	jnz	$+52     	;abs 0xfab4
        {
          if (!(BCSCTL1 == (XT2OFF + DIVA_3)))
    fa82:	5f 42 57 00 	mov.b	&0x0057,r15	
    fa86:	7f 90 b0 ff 	cmp.b	#-80,	r15	;#0xffb0
    fa8a:	14 24       	jz	$+42     	;abs 0xfab4
          BCSCTL1--;                        // Did DCO role under?, Sel lower RSEL
    fa8c:	5f 42 57 00 	mov.b	&0x0057,r15	
    fa90:	7f 53       	add.b	#-1,	r15	;r3 As==11
    fa92:	0e 3c       	jmp	$+30     	;abs 0xfab0
        }
      }
    else
      {
        DCOCTL++;                           // DCO is too slow, speed it down
    fa94:	d2 53 56 00 	inc.b	&0x0056	
        if (DCOCTL == 0x00)
    fa98:	5f 42 56 00 	mov.b	&0x0056,r15	
    fa9c:	4f 93       	tst.b	r15		
    fa9e:	0a 20       	jnz	$+22     	;abs 0xfab4
        {
          if (!(BCSCTL1 == (XT2OFF + DIVA_3 + 0x07)))
    faa0:	5f 42 57 00 	mov.b	&0x0057,r15	
    faa4:	7f 90 b7 ff 	cmp.b	#-73,	r15	;#0xffb7
    faa8:	05 24       	jz	$+12     	;abs 0xfab4
          BCSCTL1++;                        // Did DCO role over? Sel higher RSEL
    faaa:	5f 42 57 00 	mov.b	&0x0057,r15	
    faae:	5f 53       	inc.b	r15		
    fab0:	c2 4f 57 00 	mov.b	r15,	&0x0057	
        }
      }
    }
  case 10: break;                           // not used
  }
}
    fab4:	3e 41       	pop	r14		
    fab6:	3f 41       	pop	r15		
    fab8:	00 13       	reti			

0000faba <adf4113_sw_spi_write>:
#include "adf4113.h"
#include <msp430.h>
#include <inttypes.h>

void adf4113_sw_spi_write(uint32_t data) {
    faba:	0b 12       	push	r11		
    fabc:	0a 12       	push	r10		
	int i = 24;
	
	ADF4113_LE_POUT &= ~ADF4113_LE;
    fabe:	f2 f0 ef ff 	and.b	#-17,	&0x0029	;#0xffef
    fac2:	29 00 
#include "adf4113.h"
#include <msp430.h>
#include <inttypes.h>

void adf4113_sw_spi_write(uint32_t data) {
	int i = 24;
    fac4:	3b 40 18 00 	mov	#24,	r11	;#0x0018
	
	ADF4113_LE_POUT &= ~ADF4113_LE;
	while (i-- > 0) {
    fac8:	3b 53       	add	#-1,	r11	;r3 As==11
		if ((data >> i) & 0x01) {
    faca:	0c 4e       	mov	r14,	r12	
    facc:	0d 4f       	mov	r15,	r13	
    face:	4a 4b       	mov.b	r11,	r10	
    fad0:	7a f0 1f 00 	and.b	#31,	r10	;#0x001f
    fad4:	4a 93       	tst.b	r10		
    fad6:	05 24       	jz	$+12     	;abs 0xfae2
    fad8:	12 c3       	clrc			
    fada:	0d 10       	rrc	r13		
    fadc:	0c 10       	rrc	r12		
    fade:	7a 53       	add.b	#-1,	r10	;r3 As==11
    fae0:	f9 3f       	jmp	$-12     	;abs 0xfad4
    fae2:	1c f3       	and	#1,	r12	;r3 As==01
			ADF4113_DATA_POUT |= ADF4113_DATA;
    fae4:	5d 42 21 00 	mov.b	&0x0021,r13	
void adf4113_sw_spi_write(uint32_t data) {
	int i = 24;
	
	ADF4113_LE_POUT &= ~ADF4113_LE;
	while (i-- > 0) {
		if ((data >> i) & 0x01) {
    fae8:	02 24       	jz	$+6      	;abs 0xfaee
			ADF4113_DATA_POUT |= ADF4113_DATA;
    faea:	5d d3       	bis.b	#1,	r13	;r3 As==01
    faec:	02 3c       	jmp	$+6      	;abs 0xfaf2
		} else {
			ADF4113_DATA_POUT &= ~ADF4113_DATA;
    faee:	7d f0 fe ff 	and.b	#-2,	r13	;#0xfffe
    faf2:	c2 4d 21 00 	mov.b	r13,	&0x0021	
		}
		ADF4113_CLK_POUT |= ADF4113_CLK;
    faf6:	e2 d2 21 00 	bis.b	#4,	&0x0021	;r2 As==10
		ADF4113_CLK_POUT &= ~ADF4113_CLK;
    fafa:	f2 f0 fb ff 	and.b	#-5,	&0x0021	;#0xfffb
    fafe:	21 00 

void adf4113_sw_spi_write(uint32_t data) {
	int i = 24;
	
	ADF4113_LE_POUT &= ~ADF4113_LE;
	while (i-- > 0) {
    fb00:	0b 93       	tst	r11		
    fb02:	e2 23       	jnz	$-58     	;abs 0xfac8
			ADF4113_DATA_POUT &= ~ADF4113_DATA;
		}
		ADF4113_CLK_POUT |= ADF4113_CLK;
		ADF4113_CLK_POUT &= ~ADF4113_CLK;
	}
	ADF4113_LE_POUT |= ADF4113_LE;
    fb04:	f2 d0 10 00 	bis.b	#16,	&0x0029	;#0x0010
    fb08:	29 00 
}
    fb0a:	3a 41       	pop	r10		
    fb0c:	3b 41       	pop	r11		
    fb0e:	30 41       	ret			

0000fb10 <adf4113_sw_spi_init>:

void adf4113_sw_spi_init(void) {
	ADF4113_LE_POUT |= ADF4113_LE;
    fb10:	f2 d0 10 00 	bis.b	#16,	&0x0029	;#0x0010
    fb14:	29 00 
	ADF4113_LE_PDIR |= ADF4113_LE;
    fb16:	f2 d0 10 00 	bis.b	#16,	&0x002a	;#0x0010
    fb1a:	2a 00 
	ADF4113_CLK_POUT &= ~ADF4113_CLK;
    fb1c:	f2 f0 fb ff 	and.b	#-5,	&0x0021	;#0xfffb
    fb20:	21 00 
	ADF4113_CLK_PDIR |= ADF4113_CLK;
    fb22:	e2 d2 22 00 	bis.b	#4,	&0x0022	;r2 As==10
	ADF4113_DATA_POUT &= ~ADF4113_DATA;
    fb26:	f2 f0 fe ff 	and.b	#-2,	&0x0021	;#0xfffe
    fb2a:	21 00 
	ADF4113_DATA_PDIR |= ADF4113_DATA;
    fb2c:	d2 d3 22 00 	bis.b	#1,	&0x0022	;r3 As==01
}
    fb30:	30 41       	ret			

0000fb32 <adf4113_config>:
	const uint32_t r = 5;
	const uint32_t a = 12;
	const uint32_t b = 51;
	const uint32_t cpc = ADF4113_L2_CPC_560;

	adf4113_sw_spi_init();
    fb32:	b0 12 10 fb 	call	#0xfb10	

	adf4113_sw_spi_write(ADF4113_L2_CTL + ADF4113_L2_MUXOUT_DLD + ADF4113_L2_PD_POL + cpc + ADF4113_L2_PRE_16_17 + ADF4113_L2_CPC_640);
    fb36:	3e 40 92 80 	mov	#-32622,r14	;#0x8092
    fb3a:	3f 40 46 00 	mov	#70,	r15	;#0x0046
    fb3e:	b0 12 ba fa 	call	#0xfaba	
	adf4113_sw_spi_write(ADF4113_L1_CTL + (a << ADF4113_L1_A_SHIFT) + (b << ADF4113_L1_B_SHIFT));
    fb42:	3e 40 31 33 	mov	#13105,	r14	;#0x3331
    fb46:	0f 43       	clr	r15		
    fb48:	b0 12 ba fa 	call	#0xfaba	
	adf4113_sw_spi_write(ADF4113_L0_CTL + ADF4113_L0_APB2 + (r << ADF4113_L0_REFCNT_SHIFT));
    fb4c:	3e 40 14 00 	mov	#20,	r14	;#0x0014
    fb50:	2f 43       	mov	#2,	r15	;r3 As==10
    fb52:	b0 12 ba fa 	call	#0xfaba	
}
    fb56:	30 41       	ret			

0000fb58 <adf4001_sw_spi_write>:
#include "adf4001.h"
#include <msp430.h>
#include <inttypes.h>

void adf4001_sw_spi_write(uint32_t data) {
    fb58:	0b 12       	push	r11		
    fb5a:	0a 12       	push	r10		
	int i = 24;
	
	ADF4001_LE_POUT &= ~ADF4001_LE;
    fb5c:	f2 f0 f7 ff 	and.b	#-9,	&0x0021	;#0xfff7
    fb60:	21 00 
#include "adf4001.h"
#include <msp430.h>
#include <inttypes.h>

void adf4001_sw_spi_write(uint32_t data) {
	int i = 24;
    fb62:	3b 40 18 00 	mov	#24,	r11	;#0x0018
	
	ADF4001_LE_POUT &= ~ADF4001_LE;
	while (i-- > 0) {
    fb66:	3b 53       	add	#-1,	r11	;r3 As==11
		if ((data >> i) & 0x01) {
    fb68:	0c 4e       	mov	r14,	r12	
    fb6a:	0d 4f       	mov	r15,	r13	
    fb6c:	4a 4b       	mov.b	r11,	r10	
    fb6e:	7a f0 1f 00 	and.b	#31,	r10	;#0x001f
    fb72:	4a 93       	tst.b	r10		
    fb74:	05 24       	jz	$+12     	;abs 0xfb80
    fb76:	12 c3       	clrc			
    fb78:	0d 10       	rrc	r13		
    fb7a:	0c 10       	rrc	r12		
    fb7c:	7a 53       	add.b	#-1,	r10	;r3 As==11
    fb7e:	f9 3f       	jmp	$-12     	;abs 0xfb72
    fb80:	1c f3       	and	#1,	r12	;r3 As==01
			ADF4001_DATA_POUT |= ADF4001_DATA;
    fb82:	5d 42 21 00 	mov.b	&0x0021,r13	
void adf4001_sw_spi_write(uint32_t data) {
	int i = 24;
	
	ADF4001_LE_POUT &= ~ADF4001_LE;
	while (i-- > 0) {
		if ((data >> i) & 0x01) {
    fb86:	03 24       	jz	$+8      	;abs 0xfb8e
			ADF4001_DATA_POUT |= ADF4001_DATA;
    fb88:	7d d0 10 00 	bis.b	#16,	r13	;#0x0010
    fb8c:	02 3c       	jmp	$+6      	;abs 0xfb92
		} else {
			ADF4001_DATA_POUT &= ~ADF4001_DATA;
    fb8e:	7d f0 ef ff 	and.b	#-17,	r13	;#0xffef
    fb92:	c2 4d 21 00 	mov.b	r13,	&0x0021	
		}
		ADF4001_CLK_POUT |= ADF4001_CLK;
    fb96:	f2 d0 20 00 	bis.b	#32,	&0x0021	;#0x0020
    fb9a:	21 00 
		ADF4001_CLK_POUT &= ~ADF4001_CLK;
    fb9c:	f2 f0 df ff 	and.b	#-33,	&0x0021	;#0xffdf
    fba0:	21 00 

void adf4001_sw_spi_write(uint32_t data) {
	int i = 24;
	
	ADF4001_LE_POUT &= ~ADF4001_LE;
	while (i-- > 0) {
    fba2:	0b 93       	tst	r11		
    fba4:	e0 23       	jnz	$-62     	;abs 0xfb66
			ADF4001_DATA_POUT &= ~ADF4001_DATA;
		}
		ADF4001_CLK_POUT |= ADF4001_CLK;
		ADF4001_CLK_POUT &= ~ADF4001_CLK;
	}
	ADF4001_LE_POUT |= ADF4001_LE;
    fba6:	f2 d2 21 00 	bis.b	#8,	&0x0021	;r2 As==11
}
    fbaa:	3a 41       	pop	r10		
    fbac:	3b 41       	pop	r11		
    fbae:	30 41       	ret			

0000fbb0 <adf4001_sw_spi_init>:

void adf4001_sw_spi_init(void) {
	ADF4001_LE_POUT |= ADF4001_LE;
    fbb0:	f2 d2 21 00 	bis.b	#8,	&0x0021	;r2 As==11
	ADF4001_LE_PDIR |= ADF4001_LE;
    fbb4:	f2 d2 22 00 	bis.b	#8,	&0x0022	;r2 As==11
	ADF4001_CLK_POUT &= ~ADF4001_CLK;
    fbb8:	f2 f0 df ff 	and.b	#-33,	&0x0021	;#0xffdf
    fbbc:	21 00 
	ADF4001_CLK_PDIR |= ADF4001_CLK;
    fbbe:	f2 d0 20 00 	bis.b	#32,	&0x0022	;#0x0020
    fbc2:	22 00 
	ADF4001_DATA_POUT &= ~ADF4001_DATA;
    fbc4:	f2 f0 ef ff 	and.b	#-17,	&0x0021	;#0xffef
    fbc8:	21 00 
	ADF4001_DATA_PDIR |= ADF4001_DATA;
    fbca:	f2 d0 10 00 	bis.b	#16,	&0x0022	;#0x0010
    fbce:	22 00 
}
    fbd0:	30 41       	ret			

0000fbd2 <adf4001_config>:

void adf4001_config(void) {
	adf4001_sw_spi_init();
    fbd2:	b0 12 b0 fb 	call	#0xfbb0	

	adf4001_sw_spi_write(ADF4001_R0);
    fbd6:	2e 42       	mov	#4,	r14	;r2 As==10
    fbd8:	2f 43       	mov	#2,	r15	;r3 As==10
    fbda:	b0 12 58 fb 	call	#0xfb58	
	adf4001_sw_spi_write(ADF4001_R1);
    fbde:	3e 40 01 e8 	mov	#-6143,	r14	;#0xe801
    fbe2:	3f 40 03 00 	mov	#3,	r15	;#0x0003
    fbe6:	b0 12 58 fb 	call	#0xfb58	
	adf4001_sw_spi_write(ADF4001_R2);
    fbea:	3e 40 92 80 	mov	#-32622,r14	;#0x8092
    fbee:	3f 40 03 00 	mov	#3,	r15	;#0x0003
    fbf2:	b0 12 58 fb 	call	#0xfb58	
}
    fbf6:	30 41       	ret			

0000fbf8 <memcpy>:
    fbf8:	0b 12       	push	r11		
    fbfa:	0a 12       	push	r10		
    fbfc:	09 12       	push	r9		
    fbfe:	08 12       	push	r8		
    fc00:	07 12       	push	r7		
    fc02:	0d 93       	tst	r13		
    fc04:	70 24       	jz	$+226    	;abs 0xfce6
    fc06:	0f 9e       	cmp	r14,	r15	
    fc08:	6e 24       	jz	$+222    	;abs 0xfce6
    fc0a:	34 2c       	jc	$+106    	;abs 0xfc74
    fc0c:	0c 4e       	mov	r14,	r12	
    fc0e:	0c df       	bis	r15,	r12	
    fc10:	1c f3       	and	#1,	r12	;r3 As==01
    fc12:	1b 24       	jz	$+56     	;abs 0xfc4a
    fc14:	0c 4e       	mov	r14,	r12	
    fc16:	0c ef       	xor	r15,	r12	
    fc18:	1c f3       	and	#1,	r12	;r3 As==01
    fc1a:	07 20       	jnz	$+16     	;abs 0xfc2a
    fc1c:	2d 93       	cmp	#2,	r13	;r3 As==10
    fc1e:	07 28       	jnc	$+16     	;abs 0xfc2e
    fc20:	0b 4e       	mov	r14,	r11	
    fc22:	1b f3       	and	#1,	r11	;r3 As==01
    fc24:	2c 43       	mov	#2,	r12	;r3 As==10
    fc26:	0c 8b       	sub	r11,	r12	
    fc28:	03 3c       	jmp	$+8      	;abs 0xfc30
    fc2a:	0c 4d       	mov	r13,	r12	
    fc2c:	01 3c       	jmp	$+4      	;abs 0xfc30
    fc2e:	1c 43       	mov	#1,	r12	;r3 As==01
    fc30:	0d 8c       	sub	r12,	r13	
    fc32:	0a 4c       	mov	r12,	r10	
    fc34:	09 4e       	mov	r14,	r9	
    fc36:	0b 4f       	mov	r15,	r11	
    fc38:	fb 49 00 00 	mov.b	@r9+,	0(r11)	;0x0000(r11)
    fc3c:	1b 53       	inc	r11		
    fc3e:	3a 53       	add	#-1,	r10	;r3 As==11
    fc40:	fb 23       	jnz	$-8      	;abs 0xfc38
    fc42:	0a 4f       	mov	r15,	r10	
    fc44:	0a 5c       	add	r12,	r10	
    fc46:	0e 5c       	add	r12,	r14	
    fc48:	01 3c       	jmp	$+4      	;abs 0xfc4c
    fc4a:	0a 4f       	mov	r15,	r10	
    fc4c:	0b 4d       	mov	r13,	r11	
    fc4e:	12 c3       	clrc			
    fc50:	0b 10       	rrc	r11		
    fc52:	0b 24       	jz	$+24     	;abs 0xfc6a
    fc54:	09 4b       	mov	r11,	r9	
    fc56:	08 4e       	mov	r14,	r8	
    fc58:	0c 4a       	mov	r10,	r12	
    fc5a:	bc 48 00 00 	mov	@r8+,	0(r12)	;0x0000(r12)
    fc5e:	2c 53       	incd	r12		
    fc60:	39 53       	add	#-1,	r9	;r3 As==11
    fc62:	fb 23       	jnz	$-8      	;abs 0xfc5a
    fc64:	0b 5b       	rla	r11		
    fc66:	0e 5b       	add	r11,	r14	
    fc68:	0a 5b       	add	r11,	r10	
    fc6a:	1d f3       	and	#1,	r13	;r3 As==01
    fc6c:	3c 24       	jz	$+122    	;abs 0xfce6
    fc6e:	ea 4e 00 00 	mov.b	@r14,	0(r10)	;0x0000(r10)
    fc72:	39 3c       	jmp	$+116    	;abs 0xfce6
    fc74:	0e 5d       	add	r13,	r14	
    fc76:	0c 4f       	mov	r15,	r12	
    fc78:	0c 5d       	add	r13,	r12	
    fc7a:	0b 4c       	mov	r12,	r11	
    fc7c:	0b de       	bis	r14,	r11	
    fc7e:	1b f3       	and	#1,	r11	;r3 As==01
    fc80:	1b 24       	jz	$+56     	;abs 0xfcb8
    fc82:	0b 4c       	mov	r12,	r11	
    fc84:	0b ee       	xor	r14,	r11	
    fc86:	1b f3       	and	#1,	r11	;r3 As==01
    fc88:	06 20       	jnz	$+14     	;abs 0xfc96
    fc8a:	3d 90 03 00 	cmp	#3,	r13	;#0x0003
    fc8e:	03 28       	jnc	$+8      	;abs 0xfc96
    fc90:	0b 4e       	mov	r14,	r11	
    fc92:	1b f3       	and	#1,	r11	;r3 As==01
    fc94:	01 3c       	jmp	$+4      	;abs 0xfc98
    fc96:	0b 4d       	mov	r13,	r11	
    fc98:	0d 8b       	sub	r11,	r13	
    fc9a:	09 4e       	mov	r14,	r9	
    fc9c:	0a 4c       	mov	r12,	r10	
    fc9e:	08 4b       	mov	r11,	r8	
    fca0:	08 8c       	sub	r12,	r8	
    fca2:	3a 53       	add	#-1,	r10	;r3 As==11
    fca4:	39 53       	add	#-1,	r9	;r3 As==11
    fca6:	ea 49 00 00 	mov.b	@r9,	0(r10)	;0x0000(r10)
    fcaa:	07 4a       	mov	r10,	r7	
    fcac:	07 58       	add	r8,	r7	
    fcae:	f9 23       	jnz	$-12     	;abs 0xfca2
    fcb0:	3b e3       	inv	r11		
    fcb2:	1b 53       	inc	r11		
    fcb4:	0c 5b       	add	r11,	r12	
    fcb6:	0e 5b       	add	r11,	r14	
    fcb8:	0b 4d       	mov	r13,	r11	
    fcba:	12 c3       	clrc			
    fcbc:	0b 10       	rrc	r11		
    fcbe:	0e 24       	jz	$+30     	;abs 0xfcdc
    fcc0:	0a 4b       	mov	r11,	r10	
    fcc2:	08 4e       	mov	r14,	r8	
    fcc4:	09 4c       	mov	r12,	r9	
    fcc6:	28 83       	decd	r8		
    fcc8:	29 83       	decd	r9		
    fcca:	a9 48 00 00 	mov	@r8,	0(r9)	;0x0000(r9)
    fcce:	3a 53       	add	#-1,	r10	;r3 As==11
    fcd0:	fa 23       	jnz	$-10     	;abs 0xfcc6
    fcd2:	0a 8b       	sub	r11,	r10	
    fcd4:	0b 4a       	mov	r10,	r11	
    fcd6:	0b 5b       	rla	r11		
    fcd8:	0e 5b       	add	r11,	r14	
    fcda:	0c 5b       	add	r11,	r12	
    fcdc:	1d f3       	and	#1,	r13	;r3 As==01
    fcde:	03 24       	jz	$+8      	;abs 0xfce6
    fce0:	dc 4e ff ff 	mov.b	-1(r14),-1(r12)	;0xffff(r14), 0xffff(r12)
    fce4:	ff ff 
    fce6:	37 41       	pop	r7		
    fce8:	38 41       	pop	r8		
    fcea:	39 41       	pop	r9		
    fcec:	3a 41       	pop	r10		
    fcee:	3b 41       	pop	r11		
    fcf0:	30 41       	ret			

0000fcf2 <_unexpected_>:
    fcf2:	00 13       	reti			

Disassembly of section .vectors:

0000ffe0 <__ivtbl_16>:
    ffe0:	78 f8 78 f8 78 f8 78 f8 78 f8 78 f8 78 f8 78 f8     x.x.x.x.x.x.x.x.
    fff0:	52 fa f8 f9 78 f8 78 f8 78 f8 78 f8 78 f8 00 f8     R...x.x.x.x.x...
