 -- HermesTest - Hardware Test
 -- Author: Sebastian Weiss

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity test is
	port
	(
		PHY_RX_CLOCK	: in std_logic;
		CLK_25MHZ		: in std_logic;
		LTC2208_125MHZ	: in std_logic;
		CLK_125MHZ		: in std_logic;
		PHY_CLK125		: in std_logic;
		OSC_10MHZ		: in std_logic;

		DEBUG_LED		: out std_logic_vector(10 downto 1);
		STATUS_LED		: out std_logic;
		FPGA_PLL			: out std_logic
	);
end test;

architecture behav of test is
	signal cnt25	: unsigned(24 downto 0);
	signal led25	: std_logic;
	signal cnt10	: unsigned(23 downto 0);
	signal led10	: std_logic;
	signal cnt125	: unsigned(25 downto 0);
	signal led125	: std_logic;
	signal pfd_clr	: std_logic;
	signal pfd_up	: std_logic;
	signal pfd_dn	: std_logic;
	signal clk_outdiv	: std_logic;
	signal clk_refdiv	: std_logic;
	signal cntref	: unsigned(9 downto 0);
	signal cntout	: unsigned(13 downto 0);
begin
	process begin
		wait until rising_edge(CLK_25MHZ);
		cnt25 <= cnt25 + 1;
		if cnt25 = 12500000 then
			cnt25 <= (others => '0');
			led25 <= not led25;
		end if;
	end process;
	DEBUG_LED(1) <= led25;

	process begin
		wait until rising_edge(OSC_10MHZ);
		cnt10 <= cnt10 + 1;
		if cnt10 = 5000000 then
			cnt10 <= (others => '0');
			led10 <= not led10;
		end if;
	end process;
	DEBUG_LED(2) <= led10;

	process begin
		wait until rising_edge(CLK_125MHZ);
		cnt125 <= cnt125 + 1;
		if cnt125 = 61440000 then
			cnt125 <= (others => '0');
			led125 <= not led125;
		end if;
	end process;
	DEBUG_LED(3) <= led125;

	DEBUG_LED(4) <= CLK_25MHZ;
	DEBUG_LED(5) <= OSC_10MHZ;
	DEBUG_LED(8) <= CLK_125MHZ;
	DEBUG_LED(6) <= not pfd_up;
	DEBUG_LED(7) <= not pfd_dn;
	DEBUG_LED(9) <= clk_refdiv;
	DEBUG_LED(10) <= clk_outdiv;

	pfd_ref : process(pfd_clr, clk_refdiv)
	begin
		if pfd_clr = '1' then
			pfd_up <= '0';
		elsif rising_edge(clk_refdiv) then
			pfd_up <= '1';
		end if;
	end process;

	pfd_div : process(pfd_clr, clk_outdiv)
	begin
		if pfd_clr = '1' then
			pfd_dn <= '0';
		elsif rising_edge(clk_outdiv) then
			pfd_dn <= '1';
		end if;
	end process;
	pfd_clr <= pfd_up and pfd_dn;

	process
	begin
		wait until rising_edge(CLK_125MHZ);
		cntout <= cntout + 1;
		if cntout = 12288-1 then
			cntout <= (others => '0');
		end if;
	end process;
	clk_outdiv <= cntout(13);

	process
	begin
		wait until rising_edge(OSC_10MHZ);
		cntref <= cntref + 1;
		if cntref = 1000-1 then
			cntref <= (others => '0');
		end if;
	end process;
	clk_refdiv <= cntref(9);

--	FPGA_PLL <= clk_refdiv xor clk_outdiv;
	
	FPGA_PLL <= '1' when pfd_up = '1' else
					'0' when pfd_dn = '1' else
					'Z';
end behav;
